<?php

/*
 * this class should be used to work with the public side of wordpress
 */

class dalt_Public
{

    protected static $instance = null;
    private $shared = null;
    private $tables = null;

    //Store all the shortcode IDs used in the post/page
    private static $shortcode_id_a = array();

    private function __construct()
    {

        //assign an instance of the plugin info
        $this->shared = dalt_Shared::get_instance();

        //lt shortcode
        add_shortcode('lt', array($this, 'display_league_table'));

        //enable shortcodes in text widgets if the related option is enabled
        if (intval(get_option($this->shared->get('slug') . '_widget_text_shortcode'), 10) == 1) {
            add_filter('widget_text', 'do_shortcode');
        }

        //Load public css
        add_action('wp_enqueue_scripts', array($this, 'enqueue_styles'));

        //Load public js
        add_action('wp_enqueue_scripts', array($this, 'enqueue_scripts'));

    }

    public function enqueue_styles()
    {

	    //Enqueue Google Font 1
	    if (strlen(trim(get_option($this->shared->get('slug') . "_load_google_font_1"))) > 0) {
		    wp_enqueue_style( $this->shared->get( 'slug' ) . '-google-font-1',
			    esc_url(get_option($this->shared->get('slug') . '_load_google_font_1')), false, null );
	    }

	    //Enqueue Google Font 2
	    if (strlen(trim(get_option($this->shared->get('slug') . "_load_google_font_2"))) > 0) {
		    wp_enqueue_style( $this->shared->get( 'slug' ) . '-google-font-2',
			    esc_url(get_option($this->shared->get('slug') . '_load_google_font_2')), false, null );
	    }

	    //Enqueue the main stylesheet
        wp_enqueue_style($this->shared->get('slug') . '-general', esc_url(get_option($this->shared->get('slug') . '_general_stylesheet_file_url')), array(), $this->shared->get('ver'));

    }

    public function enqueue_scripts()
    {
        wp_enqueue_script($this->shared->get('slug') . '-tablesorter', esc_url(get_option($this->shared->get('slug') . '_tablesorter_library_url')), array('jquery'), $this->shared->get('ver'), true);
        wp_enqueue_script($this->shared->get('slug') . '-general', esc_url(get_option($this->shared->get('slug') . '_general_javascript_file_url')), array('jquery'), $this->shared->get('ver'), true);
    }

    /*
     * create an instance of this class
     */
    public static function get_instance()
    {

        if (null == self::$instance) {
            self::$instance = new self;
        }

        return self::$instance;

    }

    /*
     * [lt] shortcode callback
     */
    public function display_league_table($atts)
    {

        /*
         * Parse the shortcode only inside the full content of posts and pages if the "Limit Shortcode Parsing" option
         * is enabled. Do not parse the shortcode inside feeds.
         */
        if (!is_feed() and ((is_single() or is_page()) or intval(get_option($this->shared->get('slug') . '_limit_shortcode_parsing'), 10) == 0)) {

            //get the table id
	        if(isset($atts['id'])){
		        $table_id = intval($atts['id'], 10);
	        }else{
		        return '<p>' . esc_html__('Please enter the identifier of the table.', 'dalt') . '</p>';
	        }

            //get table object
            global $wpdb;
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_table";
            $safe_sql = $wpdb->prepare("SELECT * FROM $table_name WHERE id = %d AND temporary = 0", $table_id);
            $table_obj = $wpdb->get_row($safe_sql);

            //terminate if there is no table with the specified id
            if ($table_obj === NULL) {
                return '<p>' . esc_html__('There is no table associated with this shortcode.', 'dalt') . '</p>';
            }

            //terminate if this table id has already been used
            if ( intval(get_option($this->shared->get('slug') . '_verify_single_shortcode'), 10) === 1 and
                 in_array($table_id, self::$shortcode_id_a, true)) {
                return '<p>' . esc_html__("You can't use multiple times the same shortcode.", 'dalt') . '</p>';
            }

            //store the shortcode id
            self::$shortcode_id_a[] = $table_id;

            //the tables property saves all the tables included in this post
            $this->tables[] = $table_obj;

            //generate output ------------------------------------------------------------------------------------------

            //get table data
            global $wpdb;
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
            $safe_sql = $wpdb->prepare("SELECT * FROM $table_name WHERE table_id = %d ORDER BY row_index ASC", $table_id);
            $results = $wpdb->get_results($safe_sql, ARRAY_A);

            if (intval($table_obj->enable_cell_properties, 10) == 1) {

                //get the cell properties of all the cell of the table
                global $wpdb;
                $table_name = $wpdb->prefix . $this->shared->get('slug') . "_cell";
                $safe_sql = $wpdb->prepare("SELECT * FROM $table_name WHERE table_id = %d", $table_id);
                $table_cells_properties = $wpdb->get_results($safe_sql, ARRAY_A);

            }

            //turn on output buffer
            ob_start();

            ?>

            <!-- Generate the "table" HTML element -------------------------------------------------------------------->
            <table id="dalt-table-<?php echo $table_id; ?>"
                   class="dalt-table" <?php echo $this->generate_table_data_attributes($table_obj); ?>>

	            <?php

                //Generate the caption ---------------------------------------------------------------------------------
                if(intval($table_obj->caption_show_caption, 10) === 1 and
                   strlen(trim($table_obj->caption)) > 0
                ){
                    echo '<caption>' . esc_attr(stripslashes($table_obj->caption)) . '</caption>';
                }

	            //Generate the "colgroup" HTML element -----------------------------------------------------------------
	            if ( intval( $table_obj->column_width, 10 ) === 1 ) {

		            //extract the numeric values in column width value in an array
		            $column_width_value_a = explode( ',', preg_replace( '/\s+/', '', $table_obj->column_width_value ) );

		            //if column width value doesn't include any numeric value do nothing
		            if ( count( $column_width_value_a ) > 0 ) {

			            if ( count( $column_width_value_a ) === 1 ) {

				            //if column width value is a single value apply the value to all the columns
				            $number_of_columns = $this->shared->get_number_of_columns( $table_id, true );
				            echo '<colgroup>';
				            for ( $i = 0; $i < $number_of_columns; $i ++ ) {
					            echo '<col style="width: ' . intval( $column_width_value_a[0], 10 ) . 'px;">';
				            }
				            echo '</colgroup>';

			            } else {

				            //if column width value are multiple values apply the various values to the columns
				            echo '<colgroup>';
				            foreach ( $column_width_value_a as $key => $column_width ) {
					            echo '<col style="width: ' . intval( $column_width, 10 ) . 'px;">';
				            }
				            echo '</colgroup>';

			            }


		            }

	            }

	            ?>

                <!-- Generate the "thead" HTML element ---------------------------------------------------------------->
                <thead>
                <tr>
                    <?php

                    foreach ($results as $key1 => $value) {
                        if ($key1 > 0) {
                            break;
                        }
                        $row_data = json_decode($value['content'], true);

                        foreach ($row_data as $key2 => $cell_data) {

                            if (intval($table_obj->enable_cell_properties, 10) == 1) {

                                /*
                                 * Search the properties of this cell in the array which include all the cell properties
                                 * of this table
                                 */
                                $cell_properties = false;
                                foreach ($table_cells_properties as $key => $val) {
                                    if ($val['row_index'] == $key1 and $val['column_index'] == $key2) {
                                        $cell_properties = $val;
                                        break;
                                    }
                                }

                            }

                            if (isset($cell_properties) and $cell_properties !== false and intval($table_obj->enable_cell_properties, 10) == 1) {

                                //Use the HTML content instead of the cell content if the "html_content" property is set
                                if (strlen(trim($cell_properties['html_content'])) > 0) {

                                    $cell_data = $this->shared->apply_custom_kses(stripslashes($cell_properties['html_content']));

                                } else {

                                    if (intval($table_obj->enable_cell_properties, 10) == 1) {

                                        //apply the formula defined with the "Formula" and the "Formula Data" cell properties
                                        $cell_data = $this->apply_formula($cell_data, $table_obj, $row_data, $cell_properties);

                                        /*
                                         * Use a link instead of the text if the "link" property is set and the
                                         * "Enable Manual Sorting" option is disabled
                                         */
                                        if (strlen(trim($cell_properties['link'])) > 0 and intval($table_obj->enable_manual_sorting, 10) == 0) {

                                            if (intval($cell_properties['open_link_new_tab'], 10) == 1) {
                                                $target = 'target="_blank"';
                                            } else {
                                                $target = 'target="_self"';
                                            }

                                            $cell_data = '<a ' . $target . ' href="' . esc_url(stripslashes($cell_properties['link'])) . '">' . $cell_data . '</a>';
                                        }

                                        //Add an image to the left of the cell if the "image_left" property is set
                                        if (strlen(trim($cell_properties['image_left'])) > 0) {

                                            /*
                                             * Link the image if the "image_left_link" is set and the "Enable Manual Sorting"
                                             * option is disabled
                                             */
                                            if (strlen(stripslashes($cell_properties['image_left_link'])) > 0 and intval($table_obj->enable_manual_sorting, 10) == 0) {

                                                //Set the target attribute based on the value of "image_left_open_link_new_tab"
                                                if (intval($cell_properties['image_left_open_link_new_tab'], 10) == 1) {
                                                    $target = 'target="_blank"';
                                                } else {
                                                    $target = 'target="_self"';
                                                }

                                                $cell_data = '<a class="dalt-image-left-link" ' . $target . ' href="' . esc_url(stripslashes($cell_properties['image_left_link'])) . '"><img class="dalt-image-left" src="' . esc_url(stripslashes($cell_properties['image_left'])) . '"></a>' . $cell_data;
                                            } else {
                                                $cell_data = '<img class="dalt-image-left" src="' . esc_url(stripslashes($cell_properties['image_left'])) . '">' . $cell_data;
                                            }

                                        }

                                        //Add an image to the right of the cell if the "image_right" property is set
                                        if (strlen(trim($cell_properties['image_right'])) > 0) {

                                            /*
                                             * Link the image if the "image_right_link" is set and the "Enable Manual Sorting"
                                             * option is disabled
                                             */
                                            if (strlen(trim($cell_properties['image_right_link'])) > 0 and intval($table_obj->enable_manual_sorting, 10) == 0) {

                                                //Set the target attribute based on the value of "image_right_open_link_new_tab"
                                                if (intval($cell_properties['image_right_open_link_new_tab'], 10) == 1) {
                                                    $target = 'target="_blank"';
                                                } else {
                                                    $target = 'target="_self"';
                                                }

                                                $cell_data = '<a class="dalt-image-right-link" ' . $target . ' href="' . esc_url(stripslashes($cell_properties['image_right_link'])) . '"><img class="dalt-image-right" src="' . esc_url(stripslashes($cell_properties['image_right'])) . '"></a>' . $cell_data;
                                            } else {
                                                $cell_data = '<img class="dalt-image-right" src="' . esc_url(stripslashes($cell_properties['image_right'])) . '">' . $cell_data;
                                            }

                                        }

                                    }

                                }


	                            /**
	                             * Echo the "td" element only if:
	                             *
	                             * - The Enable Sorting table field is equal to 1
	                             *
	                             * or if:
	                             *
	                             * - The Enable Sorting table field is equal to 0
	                             * - The Row Slots cell property is different from 0
	                             * - The Column Slots cell property is different from 0
	                             */
	                            if(intval($table_obj->enable_sorting, 10) === 1 or
	                               (intval($table_obj->enable_sorting, 10) === 0 and intval($cell_properties['row_slots'], 10) !== 0 and intval($cell_properties['column_slots'], 10) !== 0)
	                            ){
		                            echo '<th ' . $this->generate_cell_attributes($table_obj, $cell_properties) . '>' . $cell_data . '</th>';
	                            }

                            } else {

                                echo '<th>' . $cell_data . '</th>';

                            }

                        }

                    }

                    ?>
                </tr>
                </thead>

                <!-- Generate the "tbody" HTML element ---------------------------------------------------------------->
                <tbody>

                <?php


                foreach ($results as $key1 => $value) {
                    if ($key1 == 0) {
                        continue;
                    }
                    $row_data = json_decode($value['content'], true);
                    echo '<tr>';
                    foreach ($row_data as $key2 => $cell_data) {

                        if (intval($table_obj->enable_cell_properties, 10) == 1) {

                            /*
                             * Search the properties of this cell in the array which include all the cell properties
                             * of this table
                             */
                            $cell_properties = false;
                            foreach ($table_cells_properties as $key => $val) {
                                if ($val['row_index'] == $key1 and $val['column_index'] == $key2) {
                                    $cell_properties = $val;
                                    break;
                                }
                            }

                        }

                        if (isset($cell_properties) and $cell_properties !== false and intval($table_obj->enable_cell_properties, 10) == 1) {

                            //Use the HTML content instead of the cell content if the "html_content" property is set
                            if (strlen(trim($cell_properties['html_content'])) > 0) {

                                $cell_data = $this->shared->apply_custom_kses(stripslashes($cell_properties['html_content']));

                            } else {

                                if (intval($table_obj->enable_cell_properties, 10) == 1) {

                                    //apply the formula defined with the "Formula" and the "Formula Data" cell properties
                                    $cell_data = $this->apply_formula($cell_data, $table_obj, $row_data, $cell_properties);

                                    //Use a link instead of the text if the "link" property is set
                                    if (strlen(trim($cell_properties['link'])) > 0) {

                                        if (intval($cell_properties['open_link_new_tab'], 10) == 1) {
                                            $target = 'target="_blank"';
                                        } else {
                                            $target = 'target="_self"';
                                        }

                                        $cell_data = '<a ' . $target . ' href="' . esc_url(stripslashes($cell_properties['link'])) . '">' . $cell_data . '</a>';
                                    }

                                    //Add an image to the left of the cell if the "image_left" property is set
                                    if (strlen(trim($cell_properties['image_left'])) > 0) {

                                        //Link the image if the "image_left_link" is not empty
                                        if (strlen(trim($cell_properties['image_left_link'])) > 0) {

                                            //Set the target attribute based on the value of "image_left_open_link_new_tab"
                                            if (intval($cell_properties['image_left_open_link_new_tab'], 10) == 1) {
                                                $target = 'target="_blank"';
                                            } else {
                                                $target = 'target="_self"';
                                            }

                                            $cell_data = '<a class="dalt-image-left-link" ' . $target . ' href="' . esc_url(stripslashes($cell_properties['image_left_link'])) . '"><img class="dalt-image-left" src="' . esc_url(stripslashes($cell_properties['image_left'])) . '"></a>' . $cell_data;
                                        } else {
                                            $cell_data = '<img class="dalt-image-left" src="' . esc_url(stripslashes($cell_properties['image_left'])) . '">' . $cell_data;
                                        }

                                    }

                                    //Add an image to the left of the cell if the "image_right" property is set
                                    if (strlen(trim($cell_properties['image_right'])) > 0) {

                                        //Link the image if the "image_right_link" is not empty
                                        if (strlen(trim($cell_properties['image_right_link'])) > 0) {

                                            //Set the target attribute based on the value of "image_right_open_link_new_tab"
                                            if (intval($cell_properties['image_right_open_link_new_tab'], 10) == 1) {
                                                $target = 'target="_blank"';
                                            } else {
                                                $target = 'target="_self"';
                                            }

                                            $cell_data = '<a class="dalt-image-right-link" ' . $target . ' href="' . esc_url(stripslashes($cell_properties['image_right_link'])) . '"><img class="dalt-image-right" src="' . esc_url(stripslashes($cell_properties['image_right'])) . '"></a>' . $cell_data;
                                        } else {
                                            $cell_data = '<img class="dalt-image-right" src="' . esc_url(stripslashes($cell_properties['image_right'])) . '">' . $cell_data;
                                        }

                                    }

                                }

                            }

	                        /**
	                         * Echo the "td" element only if:
	                         *
                             * - The Enable Sorting table field is equal to 1
                             *
                             * or if:
                             *
	                         * - The Enable Sorting table field is equal to 0
	                         * - The Row Slots cell property is different from 0
	                         * - The Column Slots cell property is different from 0
	                         */
	                        if(intval($table_obj->enable_sorting, 10) === 1 or
                               (intval($table_obj->enable_sorting, 10) === 0 and intval($cell_properties['row_slots'], 10) !== 0 and intval($cell_properties['column_slots'], 10) !== 0)
                            ){
		                        echo '<td ' . $this->generate_cell_attributes($table_obj, $cell_properties) . '>' . $cell_data . '</td>';
	                        }

                        } else {

                            echo '<td>' . $cell_data . '</td>';

                        }

                    }
                    echo '</tr>';
                }

                ?>


                </tbody>

            </table>

            <?php

            $out = ob_get_clean();

            //If the container is enabled include the table in a container
            if (intval($table_obj->enable_container, 10) == 1) {
                $out = '<div class="dalt-table-container">' . $out . '</div>';
            }

            return $out;

        }

    }

    /*
     * Generates the data attributes placed in the starting "table" tag of the table
     *
     * @param $table_obj An object with all the properties of the table
     * @return String The string which includes all the data attribute
     */
    public function generate_table_data_attributes($table_obj)
    {

        //sorting options
        $out = 'data-enable-sorting="' . intval($table_obj->enable_sorting, 10) . '" ';
        $out .= 'data-enable-manual-sorting="' . intval($table_obj->enable_manual_sorting, 10) . '" ';
        $out .= 'data-show-position="' . intval($table_obj->show_position, 10) . '" ';
        $out .= 'data-position-side="' . esc_attr(stripslashes($table_obj->position_side)) . '" ';
        $out .= 'data-position-label="' . esc_attr(stripslashes($table_obj->position_label)) . '" ';
        $out .= 'data-number-format="' . intval($table_obj->number_format, 10) . '" ';
        $out .= 'data-order-desc-asc-1="' . intval($table_obj->order_desc_asc_1, 10) . '" ';
        $out .= 'data-order-by-1="' . intval($table_obj->order_by_1, 10) . '" ';
        $out .= 'data-order-data-type-1="' . esc_attr(stripslashes($table_obj->order_data_type_1)) . '" ';
        $out .= 'data-order-date-format-1="' . esc_attr(stripslashes($table_obj->order_date_format_1)) . '" ';
        $out .= 'data-order-desc-asc-2="' . intval($table_obj->order_desc_asc_2, 10) . '"';
        $out .= 'data-order-by-2="' . intval($table_obj->order_by_2, 10) . '"';
        $out .= 'data-order-data-type-2="' . esc_attr(stripslashes($table_obj->order_data_type_2)) . '" ';
        $out .= 'data-order-date-format-2="' . esc_attr(stripslashes($table_obj->order_date_format_2)) . '" ';
        $out .= 'data-order-desc-asc-3="' . intval($table_obj->order_desc_asc_3, 10) . '" ';
        $out .= 'data-order-by-3="' . intval($table_obj->order_by_3, 10) . '" ';
        $out .= 'data-order-data-type-3="' . esc_attr(stripslashes($table_obj->order_data_type_3)) . '" ';
        $out .= 'data-order-date-format-3="' . esc_attr(stripslashes($table_obj->order_date_format_3)) . '" ';
        $out .= 'data-order-desc-asc-4="' . intval($table_obj->order_desc_asc_4, 10) . '" ';
        $out .= 'data-order-by-4="' . intval($table_obj->order_by_4, 10) . '" ';
        $out .= 'data-order-data-type-4="' . esc_attr(stripslashes($table_obj->order_data_type_4)) . '" ';
        $out .= 'data-order-date-format-4="' . esc_attr(stripslashes($table_obj->order_date_format_4)) . '" ';
        $out .= 'data-order-desc-asc-5="' . intval($table_obj->order_desc_asc_5, 10) . '" ';
        $out .= 'data-order-by-5="' . intval($table_obj->order_by_5, 10) . '" ';
        $out .= 'data-order-data-type-5="' . esc_attr(stripslashes($table_obj->order_data_type_5)) . '" ';
        $out .= 'data-order-date-format-5="' . esc_attr(stripslashes($table_obj->order_date_format_5)) . '" ';

        //style options
	    $out .= 'data-table-layout="' . intval($table_obj->table_layout, 10) . '" ';
        $out .= 'data-table-width="' . intval($table_obj->table_width, 10) . '" ';
        $out .= 'data-table-width-value="' . intval($table_obj->table_width_value, 10) . '" ';
        $out .= 'data-table-minimum-width="' . intval($table_obj->table_minimum_width, 10) . '" ';
        $out .= 'data-table-margin-top="' . intval($table_obj->table_margin_top, 10) . '" ';
        $out .= 'data-table-margin-bottom="' . intval($table_obj->table_margin_bottom, 10) . '" ';
        $out .= 'data-enable-container="' . intval($table_obj->enable_container, 10) . '" ';
        $out .= 'data-container-width="' . intval($table_obj->container_width, 10) . '" ';
        $out .= 'data-container-height="' . intval($table_obj->container_height, 10) . '" ';
	    $out .= 'data-show-header="' . intval($table_obj->show_header, 10) . '" ';
	    $out .= 'data-sticky-header="' . intval($table_obj->sticky_header, 10) . '" ';
        $out .= 'data-header-font-size="' . intval($table_obj->header_font_size, 10) . '" ';
        $out .= 'data-header-font-family="' . htmlspecialchars(stripslashes($table_obj->header_font_family), ENT_COMPAT) . '" ';
        $out .= 'data-header-font-weight="' . esc_attr(stripslashes($table_obj->header_font_weight)) . '" ';
        $out .= 'data-header-font-style="' . esc_attr(stripslashes($table_obj->header_font_style)) . '" ';
        $out .= 'data-header-background-color="' . esc_attr(stripslashes($table_obj->header_background_color)) . '" ';
        $out .= 'data-header-font-color="' . esc_attr(stripslashes($table_obj->header_font_color)) . '" ';
        $out .= 'data-header-link-color="' . esc_attr(stripslashes($table_obj->header_link_color)) . '" ';
        $out .= 'data-header-border-color="' . esc_attr(stripslashes($table_obj->header_border_color)) . '" ';
        $out .= 'data-header-position-alignment="' . esc_attr(stripslashes($table_obj->header_position_alignment)) . '" ';
        $out .= 'data-body-font-size="' . intval($table_obj->body_font_size, 10) . '" ';
        $out .= 'data-body-font-family="' . htmlspecialchars(stripslashes($table_obj->body_font_family), ENT_COMPAT) . '" ';
        $out .= 'data-body-font-weight="' . esc_attr(stripslashes($table_obj->body_font_weight)) . '" ';
        $out .= 'data-body-font-style="' . esc_attr(stripslashes($table_obj->body_font_style)) . '" ';
        $out .= 'data-even-rows-background-color="' . esc_attr(stripslashes($table_obj->even_rows_background_color)) . '" ';
        $out .= 'data-odd-rows-background-color="' . esc_attr(stripslashes($table_obj->odd_rows_background_color)) . '" ';
        $out .= 'data-even-rows-font-color="' . esc_attr(stripslashes($table_obj->even_rows_font_color)) . '" ';
        $out .= 'data-even-rows-link-color="' . esc_attr(stripslashes($table_obj->even_rows_link_color)) . '" ';
        $out .= 'data-odd-rows-font-color="' . esc_attr(stripslashes($table_obj->odd_rows_font_color)) . '" ';
        $out .= 'data-odd-rows-link-color="' . esc_attr(stripslashes($table_obj->odd_rows_link_color)) . '" ';
        $out .= 'data-rows-border-color="' . esc_attr(stripslashes($table_obj->rows_border_color)) . '" ';
	    $out .= 'data-caption-show-caption="' . esc_attr(stripslashes($table_obj->caption_show_caption)) . '" ';
	    $out .= 'data-caption-caption-side="' . esc_attr(stripslashes($table_obj->caption_caption_side)) . '" ';
	    $out .= 'data-caption-text-align="' . esc_attr(stripslashes($table_obj->caption_text_align)) . '" ';
	    $out .= 'data-caption-font-size="' . esc_attr(stripslashes($table_obj->caption_font_size)) . '" ';
	    $out .= 'data-caption-font-family="' . esc_attr(stripslashes($table_obj->caption_font_family)) . '" ';
	    $out .= 'data-caption-font-weight="' . esc_attr(stripslashes($table_obj->caption_font_weight)) . '" ';
	    $out .= 'data-caption-font-style="' . esc_attr(stripslashes($table_obj->caption_font_style)) . '" ';
	    $out .= 'data-caption-font-color="' . esc_attr(stripslashes($table_obj->caption_font_color)) . '" ';

        //autocolors options
        $out .= 'data-autocolors-priority="' . esc_attr(stripslashes($table_obj->autocolors_priority)) . '" ';
        $out .= 'data-autocolors-affected-rows-1="' . esc_attr(stripslashes($table_obj->autocolors_affected_rows_1)) . '" ';
        $out .= 'data-autocolors-rows-background-color-1="' . esc_attr(stripslashes($table_obj->autocolors_rows_background_color_1)) . '" ';
        $out .= 'data-autocolors-rows-font-color-1="' . esc_attr(stripslashes($table_obj->autocolors_rows_font_color_1)) . '" ';
        $out .= 'data-autocolors-affected-rows-2="' . esc_attr(stripslashes($table_obj->autocolors_affected_rows_2)) . '" ';
        $out .= 'data-autocolors-rows-background-color-2="' . esc_attr(stripslashes($table_obj->autocolors_rows_background_color_2)) . '" ';
        $out .= 'data-autocolors-rows-font-color-2="' . esc_attr(stripslashes($table_obj->autocolors_rows_font_color_2)) . '" ';
        $out .= 'data-autocolors-affected-rows-3="' . esc_attr(stripslashes($table_obj->autocolors_affected_rows_3)) . '" ';
        $out .= 'data-autocolors-rows-background-color-3="' . esc_attr(stripslashes($table_obj->autocolors_rows_background_color_3)) . '" ';
        $out .= 'data-autocolors-rows-font-color-3="' . esc_attr(stripslashes($table_obj->autocolors_rows_font_color_3)) . '" ';
        $out .= 'data-autocolors-affected-rows-4="' . esc_attr(stripslashes($table_obj->autocolors_affected_rows_4)) . '" ';
        $out .= 'data-autocolors-rows-background-color-4="' . esc_attr(stripslashes($table_obj->autocolors_rows_background_color_4)) . '" ';
        $out .= 'data-autocolors-rows-font-color-4="' . esc_attr(stripslashes($table_obj->autocolors_rows_font_color_4)) . '" ';
        $out .= 'data-autocolors-affected-rows-5="' . esc_attr(stripslashes($table_obj->autocolors_affected_rows_5)) . '" ';
        $out .= 'data-autocolors-rows-background-color-5="' . esc_attr(stripslashes($table_obj->autocolors_rows_background_color_5)) . '" ';
        $out .= 'data-autocolors-rows-font-color-5="' . esc_attr(stripslashes($table_obj->autocolors_rows_font_color_5)) . '" ';
        $out .= 'data-autocolors-affected-columns-1="' . esc_attr(stripslashes($table_obj->autocolors_affected_columns_1)) . '" ';
        $out .= 'data-autocolors-columns-background-color-1="' . esc_attr(stripslashes($table_obj->autocolors_columns_background_color_1)) . '" ';
        $out .= 'data-autocolors-columns-font-color-1="' . esc_attr(stripslashes($table_obj->autocolors_columns_font_color_1)) . '" ';
        $out .= 'data-autocolors-affected-columns-2="' . esc_attr(stripslashes($table_obj->autocolors_affected_columns_2)) . '" ';
        $out .= 'data-autocolors-columns-background-color-2="' . esc_attr(stripslashes($table_obj->autocolors_columns_background_color_2)) . '" ';
        $out .= 'data-autocolors-columns-font-color-2="' . esc_attr(stripslashes($table_obj->autocolors_columns_font_color_2)) . '" ';
        $out .= 'data-autocolors-affected-columns-3="' . esc_attr(stripslashes($table_obj->autocolors_affected_columns_3)) . '" ';
        $out .= 'data-autocolors-columns-background-color-3="' . esc_attr(stripslashes($table_obj->autocolors_columns_background_color_3)) . '" ';
        $out .= 'data-autocolors-columns-font-color-3="' . esc_attr(stripslashes($table_obj->autocolors_columns_font_color_3)) . '" ';
        $out .= 'data-autocolors-affected-columns-4="' . esc_attr(stripslashes($table_obj->autocolors_affected_columns_4)) . '" ';
        $out .= 'data-autocolors-columns-background-color-4="' . esc_attr(stripslashes($table_obj->autocolors_columns_background_color_4)) . '" ';
        $out .= 'data-autocolors-columns-font-color-4="' . esc_attr(stripslashes($table_obj->autocolors_columns_font_color_4)) . '" ';
        $out .= 'data-autocolors-affected-columns-5="' . esc_attr(stripslashes($table_obj->autocolors_affected_columns_5)) . '" ';
        $out .= 'data-autocolors-columns-background-color-5="' . esc_attr(stripslashes($table_obj->autocolors_columns_background_color_5)) . '" ';
        $out .= 'data-autocolors-columns-font-color-5="' . esc_attr(stripslashes($table_obj->autocolors_columns_font_color_5)) . '" ';

        //autoalignment options
        $out .= 'data-autoalignment-priority="' . esc_attr(stripslashes($table_obj->autoalignment_priority)) . '" ';
        $out .= 'data-autoalignment-affected-rows-left="' . esc_attr(stripslashes($table_obj->autoalignment_affected_rows_left)) . '" ';
        $out .= 'data-autoalignment-affected-rows-center="' . esc_attr(stripslashes($table_obj->autoalignment_affected_rows_center)) . '" ';
        $out .= 'data-autoalignment-affected-rows-right="' . esc_attr(stripslashes($table_obj->autoalignment_affected_rows_right)) . '" ';
        $out .= 'data-autoalignment-affected-columns-left="' . esc_attr(stripslashes($table_obj->autoalignment_affected_columns_left)) . '" ';
        $out .= 'data-autoalignment-affected-columns-center="' . esc_attr(stripslashes($table_obj->autoalignment_affected_columns_center)) . '" ';
        $out .= 'data-autoalignment-affected-columns-right="' . esc_attr(stripslashes($table_obj->autoalignment_affected_columns_right)) . '" ';

        //responsive options
        $out .= 'data-tablet-breakpoint="' . intval($table_obj->tablet_breakpoint, 10) . '" ';
        $out .= 'data-hide-tablet-list="' . esc_attr(stripslashes($table_obj->hide_tablet_list)) . '"';
        $out .= 'data-tablet-header-font-size="' . intval($table_obj->tablet_header_font_size, 10) . '" ';
        $out .= 'data-tablet-body-font-size="' . intval($table_obj->tablet_body_font_size, 10) . '" ';
	    $out .= 'data-tablet-caption-font-size="' . intval($table_obj->tablet_caption_font_size, 10) . '" ';
        $out .= 'data-tablet-hide-images="' . intval($table_obj->tablet_hide_images, 10) . '" ';
        $out .= 'data-phone-breakpoint="' . intval($table_obj->phone_breakpoint, 10) . '" ';
        $out .= 'data-hide-phone-list="' . esc_attr(stripslashes($table_obj->hide_phone_list)) . '" ';
        $out .= 'data-phone-header-font-size="' . intval($table_obj->phone_header_font_size, 10) . '" ';
        $out .= 'data-phone-body-font-size="' . intval($table_obj->phone_body_font_size, 10) . '" ';
	    $out .= 'data-phone-caption-font-size="' . intval($table_obj->phone_caption_font_size, 10) . '" ';
        $out .= 'data-phone-hide-images="' . intval($table_obj->phone_hide_images, 10) . '" ';

        //advanced options
        $out .= 'data-enable-cell-properties="' . intval($table_obj->enable_cell_properties, 10) . '" ';

        return $out;

    }

    /*
     * Generates the attributes associated with the cells (th and td elements) of the table
     *
     * @param $cell_properties An object with all the properties of the cell
     * @return String The string which includes all the data attribute
     */
    public function generate_cell_attributes($table_obj, $cell_properties)
    {

        $out = 'data-cell-properties="true" ';
        $out .= 'data-text-color="' . esc_attr(stripslashes($cell_properties['text_color'])) . '" ';
        $out .= 'data-background-color="' . esc_attr(stripslashes($cell_properties['background_color'])) . '" ';
        $out .= 'data-font-weight="' . esc_attr(stripslashes($cell_properties['font_weight'])) . '" ';
        $out .= 'data-font-style="' . esc_attr(stripslashes($cell_properties['font_style'])) . '" ';
        $out .= 'data-link-color="' . esc_attr(stripslashes($cell_properties['link_color'])) . '" ';
        $out .= 'data-alignment="' . esc_attr(stripslashes($cell_properties['alignment'])) . '" ';

	    if(intval($table_obj->enable_sorting, 10) === 0) {
		    $out .= 'rowspan="' . intval($cell_properties['row_slots'], 10) . '" ';
		    $out .= 'colspan="' . intval($cell_properties['column_slots'], 10) . '" ';
	    }

        return $out;

    }

    /*
     * Apply the formula defined with the "Formula" property on the indexes defined with the "Formula Data" property
     *
     * @param $cell_data The data (the value inputted on the cell) associated with the cell
     * @param $table_obj An object will all the properties of the table
     * @param $row_data An array with all the data available in the considered table row
     * @param $cell_properties An array with all the cell properties associated with the cell
     * @return The result of the formula or the unaltered $cell_data if $formula_data is empty
     */
    public function apply_formula($cell_data, $table_obj, $row_data, $cell_properties)
    {

        //get the indexes of the cell involved from formula data
        $formula_data = explode(',', str_replace(' ', '', $cell_properties['formula_data']));

        //remove columns indexes not available in the table
        foreach ($formula_data as $key => $column_index) {
            if ($column_index < 1 or $column_index > $table_obj->columns) {
                unset($formula_data[$key]);
            }
        }

        //apply formula on $cell_data only if at least one index is defined
        if (count($formula_data) > 0) {

            //perform the operation defined in $formula
            switch ($cell_properties['formula']) {

                case 'sum':

                    $result = 0;
                    foreach ($formula_data as $data_index) {

                        $result += floatval($row_data[$data_index - 1]);

                    }

                    break;

                case 'subtrac':

                    $result = 0;
                    foreach ($formula_data as $key => $data_index) {

                        if($key === 0){
                            $result = floatval($row_data[$data_index - 1]);
                        }else{
                            $result -= floatval($row_data[$data_index - 1]);
                        }

                    }

                    break;

                case 'minimum':

                    $values = array();
                    foreach ($formula_data as $data_index) {

                        $values_a[] = floatval($row_data[$data_index - 1]);

                    }

                    $result = min($values_a);

                    break;

                case 'maximum':

                    $values = array();
                    foreach ($formula_data as $data_index) {

                        $values_a[] = floatval($row_data[$data_index - 1]);

                    }

                    $result = max($values_a);

                    break;

                case 'average':

                    $result = 0;
                    foreach ($formula_data as $data_index) {

                        $result += floatval($row_data[$data_index - 1]);

                    }

                    $result = round($result / count($formula_data), intval($table_obj->formula_average_decimals, 10), intval($table_obj->formula_average_round, 10));

                    break;

            }

            return $result;

        } else {

            return $cell_data;

        }

    }

}